<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ArtisanController extends Controller
{
    //
    public function index()
    {
        $response = Http::get($this->base_url . "admin/artisans");
       //  dd($response->object()->artisans);
         
        //   $totalRequest=$response->object()->totalRequest;

        // $services=Service::all();
        return view('artisans.index', ["artisans" => $response->object()->artisans]);
        //
    }

    

    public function getArtisanService($subServiceId,$serviceId)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::get($this->base_url . "admin/subservice/".$subServiceId."/".$serviceId);
        //var_dump($response->object()->subservice);
        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        // session()->flash("success", " User unblocked successfully");
        return response()->json(["status"=>true,"name"=>$response->object()->subservice->name]);
    }


    public function unblock($uid)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url . "admin/unblock", [
            "uid" => $uid,
        ]);

        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success", " User unblocked successfully");
        return redirect()->back();
    }


    public function unBusy($uid)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url . "admin/unbusy", [
            "uid" => $uid,
        ]);

        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success", " Mark as unbusy successfully");
        return redirect()->back();
    }

    public function subscribeUser($uid)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url . "admin/subscribe_user", [
            "uid" => $uid,
        ]);

        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success", " User Subscription is successfully");
        return redirect()->back();
    }

    public function block($uid)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url . "admin/block", [
            "uid" => $uid,
        ]);

        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success", " User Blocked successfully");
        return redirect()->back();
    }
    public function verifyUser($uid)
    {
    

        // dd($request->all());

        $response = Http::post($this->base_url . "admin/verify", [
            "uid" => $uid,
        ]);

        //SubService::create(["name"=>"service_id"=>$service->id]);
        session()->flash("success", " User Verified successfully");
        return redirect()->back();
    }

    public function updateVerificationNumber(Request $request, $uid)
    {
    
        $response = Http::post($this->base_url . "admin/update-verification-number", [
            "uid" => $uid,
            "identityNumber"=>$request->identityNumber,
            "identityType"=>$request->identityType
        ]);

        //SubService::create(["name"=>"service_id"=>$service->id]);
        session()->flash("success", " User Verification number updated successfully");
        return redirect()->back();
    }
}
