<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Http;

use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\SubService;

class ServiceController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $response = Http::get($this->base_url."admin/services");
      // dd($response->json());

        // $services=Service::all();
        return view('services.index',["services"=>$response->object()->services]);
        //
    }

     public function sub_service($serviceId)
    {
        $response = Http::get($this->base_url."admin/subservices/".$serviceId);
       // $services=SubService::where("service_id",$service->id)->get();
   // dd($response->object()->services);
        return view('services.sub_service',["services"=>$response->object()->services,"service"=>$response->object()->service,"serviceId"=>$serviceId]);
        //
    }


    public function task($subServiceId,$serviceId)
    {
        $response = Http::get($this->base_url."admin/tasks/".$subServiceId.'/'.$serviceId);
       // $services=SubService::where("service_id",$service->id)->get();
      // dd($response->object());
        return view('services.task',["services"=>$response->object()->tasks,"service"=>$response->object()->service,"subService"=>$response->object()->subService,"serviceId"=>$serviceId,"subServiceId"=>$subServiceId]);
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        Service::create(["name"=>$request->name]);
        session()->flash("success","Service added successfully");
        return redirect()->back();
    }

    public function storeSubservice(Request $request,$serviceId,$userType)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url."admin/create_subservice/".$serviceId,[
            "cost"=>isset($request->cost)?(int)$request->cost:0,
            "price_guide"=>isset($request->price_guide)?$request->price_guide:"",
            "cost_variation"=>isset($request->cost_variation)?(int)$request->cost_variation:0,
            "name"=>$request->name,
            "hasTask"=>$userType==3?false:true,
            "visible"=>true
        ]);
        
        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success",$request->name." service added successfully");
        return redirect()->back();
    }

    public function storeTask(Request $request,$serviceId)
    {
        // dd($userType);

        // dd($request->all());

        $response = Http::post($this->base_url."admin/create_task/".$serviceId,[
            "cost"=>(int)$request->cost,
           // "price_guide"=>isset($request->price_guide)?$request->price_guide:"",
            "name"=>$request->name,
           // "hasTask"=>$userType==3?false:true,
            "visible"=>true
        ]);
        
        //SubService::create(["name"=>$request->name,"service_id"=>$service->id]);
        session()->flash("success",$request->name." task added successfully");
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $response = Http::post($this->base_url."admin/update_service",[
            "id"=>$id,
            "name"=>$request->name,
            "visible"=>$request->visible==1?true:false
        ]);
        
        // $service->name=$request->name;
        // $service->visibility=$request->visibility;
        // $service->save();
        session()->flash("success",$request->name." service updated successfully");
        return redirect()->back();
    }



     public function subServiceUpdate(Request $request, $id,$serviceId)
    {
        // dd($service);
        
        $response = Http::post($this->base_url."admin/update_sub_service",[
            "serviceId"=>$serviceId,
            "id"=>$id,
            "cost_variation"=>isset($request->cost_variation)?(int)$request->cost_variation:0,

            "cost"=>isset($request->cost)?(int)$request->cost:0,
            "price_guide"=>isset($request->price_guide)?$request->price_guide:"",
            "name"=>$request->name,
           // "hasTask"=>$userType==3?false:true,
            "visible"=>$request->visible==1?true:false
        ]);
        // $service->name=$request->name;
        // $service->visibility=$request->visibility;
        // $service->save();
        session()->flash("success",$request->name." service updated successfully");
        return redirect()->back();
    }

    public function taskUpdate(Request $request, $id,$serviceId)
    {
        // dd($service);
        
        $response = Http::post($this->base_url."admin/update_task",[
            "subServiceId"=>$serviceId,
            "id"=>$id,
            "cost"=>(int)$request->cost,
           // "price_guide"=>isset($request->price_guide)?$request->price_guide:"",
            "name"=>$request->name,
           // "hasTask"=>$userType==3?false:true,
            "visible"=>$request->visible==1?true:false
        ]);
        // $service->name=$request->name;
        // $service->visibility=$request->visibility;
        // $service->save();
        session()->flash("success",$request->name." task updated successfully");
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
