@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Customers</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">

                            <li class="breadcrumb-item active">Customers</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->
        <!-- <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCreate"><i class="fa fa-plus"></i> Add Service</button> -->

        <br />
        <br />
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Customers</h4>


                        <div class="table-responsive">
                            <table class="table mb-0" id="example">

                                <thead>
                                    <tr>
                                        {{-- <th>#</th> --}}
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Address</th>
                                        
                                        <th>Date Joined</th>
                                        <th>Blocked</th>
                                       
                                        <th>-</th>
                                        <th>-</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($customers as $key => $artisan)
                                        <tr>
                                            {{-- <th scope="row">{{$key+1}}</th> --}}

                                            <td>{{ $artisan->_fieldsProto->name->stringValue }}</td>
                                            <td>{{ $artisan->_fieldsProto->email->stringValue }}</td>
                                            <td>{{ $artisan->_fieldsProto->phone->stringValue }}</td>
                                            <td>{{ $artisan->_fieldsProto->address->stringValue }}</td>
                                            
                                            <td>{{ isset($artisan->_fieldsProto->created_at->stringValue)? date('Y-m-d H:i:s', strtotime($artisan->_fieldsProto->created_at->stringValue)): '--' }}
                                            </td>
                                      
                                          
                                            
                                                <td><button data-bs-toggle="modal"
                                                    data-bs-target="#modalEdit{{ $artisan->_ref->_path->segments[1] }}"
                                                    class="btn btn-primary btn-sm">Add to Wallet</button>


                                                <div class="modal fade"
                                                    id="modalEdit{{ $artisan->_ref->_path->segments[1] }}"
                                                    data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
                                                    role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <form method="POST"
                                                                action="{{ route('wallet.updateEarnings',['uid'=>$artisan->_ref->_path->segments[1]]) }}">
                                                                @method('PUT')
                                                                @csrf
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="staticBackdropLabel">Add to
                                                                        Wallet</h5>
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="mb-3">
                                                                                <label for="validationCustom01"
                                                                                    class="form-label">Amount</label>
                                                                                <input type="text" name="amount"
                                                                                    placeholder="Enter amount"
                                                                                    
                                                                                    class="form-control"
                                                                                    id="validationCustom01" required>

                                                                            </div>
                                                                        </div>

                                                                      
                                                                       


                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-light waves-effect"
                                                                        data-bs-dismiss="modal">Close</button>
                                                                    <button type="submit"
                                                                        class="btn btn-primary waves-effect waves-light">Save</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                            
                                            </td>
                                            <td>
                                                @if (!isset($artisan->_fieldsProto->blocked->booleanValue))
                                                <a href="{{ route('artisan.unblock', $artisan->_ref->_path->segments[1]) }}" onclick="return confirm('Do you want to unblock user?')"
                                                    class="btn btn-success">Unblock</a>
                                                @elseif($artisan->_fieldsProto->blocked->booleanValue)
                                                <a href="{{ route('artisan.unblock', $artisan->_ref->_path->segments[1]) }}" onclick="return confirm('Do you want to unblock user?')"
                                                    class="btn btn-success">UnBlock</a>
                                                @else
                                                <a href="{{ route('artisan.block', $artisan->_ref->_path->segments[1]) }}" onclick="return confirm('Do you want to block user?')"
                                                    class="btn btn-danger">Block</a>
                                                @endif
                                            </td>
                                            <td></td>
                                    @endforeach

                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('#example').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
        });
    </script>
@endsection
