@extends('layouts.app')

@section('content')

    <div class="container-fluid">
        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0">Requests</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            
                                            <li class="breadcrumb-item active">Requests</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- end page title -->
                        <!-- <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCreate"><i class="fa fa-plus"></i> Add Service</button> -->
                       
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-1 overflow-hidden">
                                                        <p class="text-truncate font-size-14 mb-2">Total Active Request</p>
                                                        <h4 class="mb-0">{{$activeRequests}}</h4>
                                                    </div>
                                                    <div class="text-primary ms-auto">
                                                        <i class="ri-stack-line font-size-24"></i>
                                                    </div>
                                                </div>
                                            </div>
    
                                            <!-- <div class="card-body border-top py-3">
                                                <div class="text-truncate">
                                                    <span class="badge badge-soft-success font-size-11"><i class="mdi mdi-menu-up"> </i> 2.4% </span>
                                                    <span class="text-muted ms-2">From previous period</span>
                                                </div>
                                            </div> -->
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-1 overflow-hidden">
                                                        <p class="text-truncate font-size-14 mb-2">Total Marked Completed By Artisan</p>
                                                        <h4 class="mb-0">{{$markedCompletedByArtisan}}</h4>
                                                    </div>
                                                    <div class="text-primary ms-auto">
                                                        <i class="ri-store-2-line font-size-24"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-1 overflow-hidden">
                                                        <p class="text-truncate font-size-14 mb-2">Total Completed And Paid Requests</p>
                                                        <h4 class="mb-0">{{$completedPaidRequest}}</h4>
                                                    </div>
                                                    <div class="text-primary ms-auto">
                                                        <i class="ri-store-2-line font-size-24"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                     <div class="col-md-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-1 overflow-hidden">
                                                        <p class="text-truncate font-size-14 mb-2">Total Denied Request</p>
                                                        <h4 class="mb-0">{{$deniedPayment}}</h4>
                                                    </div>
                                                    <div class="text-primary ms-auto">
                                                        <i class="ri-store-2-line font-size-24"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-1 overflow-hidden">
                                                        <p class="text-truncate font-size-14 mb-2">Total Canceled Request</p>
                                                        <h4 class="mb-0">{{$canceledRequest}}</h4>
                                                    </div>
                                                    <div class="text-primary ms-auto">
                                                        <i class="ri-briefcase-4-line font-size-24"></i>
                                                    </div>
                                                </div>
                                            </div>
                                           
                                        </div>
                                    </div>

                                    

                                </div>
                                <!-- end row -->
    
                               
                            </div>
    
                        </div>
                        <br/>
                        <br/>
        <div class="row">
             <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title">Requests</h4>

                                        
                                        <div class="table-responsive">
                                            <table class="table mb-0"  id="example">
        
                                                <thead>
                                                    <tr>
                                                        {{-- <th>#</th> --}}
                                                        <th>Date Request</th>
                                                        <th>Customer Name</th>
                                                        <th>Customer Phone</th>
                                                        <th>Service</th>
                                                        <th>Address</th>
                                                        <th>Destination</th>
                                                        <th>Amount</th>
                                                        <th>Status</th>
                                                        <th>Arrived?</th>
                                                        <th>Completion Time</th>
                                                        <th>Reason</th>
                                                        <th>Artisan</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($totalRequest as $key=> $request)
                                                   <tr>
                                                    {{-- <th scope="row">{{$key+1}}</th> --}}
                                                    <td>{{date("Y-m-d H:i:s",strtotime($request->created_at))}}</td>
                                                    <td>{{$request->customer_name}}</td>
                                                    <td>{{$request->customer_phone}}</td>
                                                    <td>{{$request->service_name}}</td>
                                                    <td>{{$request->address}}</td>
                                                    <td>{{isset($request->address_destination)?$request->address_destination:'-'}}</td>
                                                    <td>{{'N'.$request->amount}}</td>
                                                    <td>
                                                        @if ($request->requestStatus==0)
                                                            <span class="text text-danger">CANCEL</span>
                                                            @elseif($request->requestStatus==1)
                                                            <span class="text text-warning">NOT PAID</span>
                                                            @elseif($request->requestStatus==2)
                                                            <span class="text text-warning">ACCEPTED BUT NOT PAID</span>
                                                            @elseif($request->requestStatus==3)
                                                            <span class="text text-pending">ACTIVE</span>
                                                            @elseif($request->requestStatus==4)
                                                            <span class="text text-info">COMPLETED BY ARTISAN</span>
                                                            @elseif($request->requestStatus==5)
                                                            <span class="text text-success">CONFIRMED BY CUSTOMER</span>
                                                            @elseif($request->requestStatus==6)
                                                            <span class="text text-danger">DENIED PAYMENT</span>
                                                            @elseif($request->requestStatus==7)
                                                            <span class="text text-success">COMPLETED AND PAID</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if (isset($request->hasArrived) && $request->hasArrived)
                                                            <span>YES ( {{$request->time_artisan_arrived}})</span>
                                                            @elseif(isset($request->hasArrived) && !$request->hasArrived)
                                                            <span>NO </span>
                                                            @else
                                                            <span>--</span>
                                                        @endif
                                                    </td>
                                                    <td>{{isset($request->confirm_at)?$request->confirm_at:"-"}}</td>
                                                    <td>{{isset($request->reason)?$request->reason:"--"}}</td>
                                                    <td>{{isset($request->artisan->name)?$request->artisan->name."(".$request->artisan->phone.")":"-"}}</td>
                                                    @endforeach

                                                </tr>
</tbody>


<tfoot>
    <tr>
        {{-- <th>#</th> --}}
        <th>Date Request</th>
        <th>Customer Name</th>
        <th>Customer Phone</th>
        <th>Service</th>
        <th>Address</th>
        <th>Destination</th>
        <th>Amount</th>
        <th>Status</th>
        <th>Arrived?</th>
        <th>Completion Time</th>
        <th>Reason</th>
        <th>Artisan</th>
    </tr>
</tfoot>
                                            </table>
                                        </div>
        
                                    </div>
                                </div>
                            </div>
                            
        </div>
    </div>




@endsection

@section('script')
<script>
   $(document).ready(function() {
    $('#example').DataTable();
} );
</script>
@endsection
