@extends('layouts.app')

@section('content')

    <div class="container-fluid">
        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0"><a href="{{ route('service.index') }}" class="btn btn-danger "><i class="fa fa-arrow-left"></i></a> {{$service->name}} Service</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            
                                            <li class="breadcrumb-item active">List {{$service->name}} Services</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- end page title -->
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCreate"><i class="fa fa-plus"></i> Add Service to {{$service->name}} </button>
                        <br/>
                        <br/>
        <div class="row">
             <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title">{{$service->name}} Services</h4>
                                    
                                        
                                        <div class="table-responsive">
                                            <table class="table mb-0">
        
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Name</th>
                                                        <th>{{$service->userType==2?"Daily Rate":"Cost Per KM"}}(N)</th>
                                                        <th>{{$service->userType==3?"Cost Variation(N)":"-"}}</th>

                                                        <th>{{$service->userType==4?"Price Guide":"-"}}</th>

                                                        <th>Visibility</th>
                                                        <th></th>
                                                       <th></th>
                                                        
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($services as $key=>$sub_service)
                                                 
                                                    <tr>
                                                        <th scope="row">{{$key+1}}</th>
                                                        <td>{{$sub_service->_fieldsProto->name->stringValue}}</td>
                                                        <td>{{$service->userType==4?'-':$sub_service->_fieldsProto->cost->integerValue}}</td>
                                                        <td>{{$service->userType==3?isset($sub_service->_fieldsProto->cost_variation->integerValue)?$sub_service->_fieldsProto->cost_variation->integerValue:0:"N/A"}}</td>
                                                        <td>{{$service->userType==4? $sub_service->_fieldsProto->price_guide->stringValue:"-"}}</td>
                                                        <td><span class="{{$sub_service->_fieldsProto->visible->booleanValue?'fa fa-check':'fa fa-close'}}"></span></td>
                                                        <td><button data-bs-toggle="modal" data-bs-target="#modalEdit{{$sub_service->_ref->_path->segments[3]}}" class="btn btn-primary btn-sm">Edit</button>


                                                            <div class="modal fade" id="modalEdit{{$sub_service->_ref->_path->segments[3]}}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <form method="POST" action="{{ route('service.subServiceUpdate',['id'=>$sub_service->_ref->_path->segments[3],'serviceId'=>$serviceId]) }}">
                                                                @method('PUT')
                                                            @csrf
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="staticBackdropLabel">Edit Service</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                 <div class="row">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom01" class="form-label">Name</label>
                                                        <input type="text" name="name" placeholder="Enter Service Name" value="{{$sub_service->_fieldsProto->name->stringValue}}" class="form-control" id="validationCustom01"required>
                                                      
                                                    </div>
                                                </div>

                                                @if($service->userType<4)
                                                
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom02" class="form-label">{{$service->userType==2?"Daily Rate":"Cost Per KM"}}(N)</label>
                                                        <input type="text" name="cost" value="{{$sub_service->_fieldsProto->cost->integerValue}}" class="form-control" id="validationCustom02"required>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @if($service->userType==3)
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom02" class="form-label">Cost Variation (N) </label>
                                                        <input type="text" value="{{isset($sub_service->_fieldsProto->cost_variation->integerValue)?$sub_service->_fieldsProto->cost_variation->integerValue:0}}" name="cost_variation" class="form-control" id="validationCustom02"required>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @if($service->userType==4)
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom035" class="form-label">Price Guide</label>
                                                        <textarea type="text" name="price_guide" class="form-control" id="validationCustom035" >
                                                            {{$sub_service->_fieldsProto->price_guide->stringValue}}
                                                        </textarea>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif


                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom01" class="form-label">Visibility</label>
                                                    <select class="form-control" name="visible">
                                                        <option value="1" {{$sub_service->_fieldsProto->visible->booleanValue?'selected':''}} >Visible</option>
                                                        
                                                        <option {{!$sub_service->_fieldsProto->visible->booleanValue?'selected':''}} value="0">Hidden</option>
                                                    </select>
                                                </div>
                                                 
                                            </div>
                                            </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">Close</button>
                                                                <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
                                                            </div>
                                                        </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                        </td>
                                                        
                                                        <td>
                                                            @if($service->userType==2)
                                                            <a href="{{ route('service.tasks',['subServiceId'=>$sub_service->_ref->_path->segments[3],'serviceId'=>$serviceId]) }}"  class="btn btn-primary btn-sm"><i class="fa fa-more"></i> Add Task</a>
                                                            @endif
                                                        </td>  
                                                    </tr>

                                                    @empty
                                                    <div class="alert alert-sm alert-danger alert-dismissible" role="alert">
         
          <i class="fa fa-exclamation-circle"></i><strong>Info!</strong> No Services Created
       </div>
                                                    @endforelse
                                                   
                                                </tbody>
                                            </table>
                                        </div>
        
                                    </div>
                                </div>
                            </div>
                            
        </div>
    </div>




<!-- Modal -->

<div class="modal fade" id="modalCreate" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <form method="POST" action="{{ route('service.sub_service.store',['serviceId'=>$serviceId,'userType'=>$service->userType]) }}">
                                                            @csrf
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="staticBackdropLabel">Add Service</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                 <div class="row">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom01" class="form-label">Name</label>
                                                        <input type="text" name="name" placeholder="Enter Service for {{$service->name}} " class="form-control" id="validationCustom01"required>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @if($service->userType<4)
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom02" class="form-label">{{$service->userType==2?"Daily Rate":"Cost Per KM"}}(N)</label>
                                                        <input type="text" name="cost" class="form-control" id="validationCustom02"required>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($service->userType==3)
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom02" class="form-label">(N) Cost Variation</label>
                                                        <input type="text" name="cost_variation" class="form-control" id="validationCustom02"required>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @if($service->userType==4)
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationCustom03" class="form-label">Price Guide</label>
                                                        <textarea type="text" name="price_guide" class="form-control" id="validationCustom03" ></textarea>
                                                        <div class="valid-feedback">
                                                            Looks good!
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">Close</button>
                                                                <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
                                                            </div>
                                                        </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                
@endsection
