<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');


Auth::routes();
Route::middleware(['auth'])->group(function () {
	Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');

	Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
	Route::get('service', [App\Http\Controllers\ServiceController::class, 'index'])->name('service.index');

	Route::get('booking', [App\Http\Controllers\BookingController::class, 'index'])->name('booking.index');

	Route::get('customer', [App\Http\Controllers\CustomerController::class, 'index'])->name('customer.index');
	Route::get('artisan', [App\Http\Controllers\ArtisanController::class, 'index'])->name('artisan.index');

	//Route::get('service',[App\Http\Controllers\ServiceController::class,'index'])->name('service.index');



	Route::get('service/{serviceId}/sub_service', [App\Http\Controllers\ServiceController::class, 'sub_service'])->name('service.sub_service');
	Route::get('artisan/{uid}/verify', [App\Http\Controllers\ArtisanController::class, 'verifyUser'])->name('artisan.verify');
	Route::get('artisan/{uid}/subscribe_user', [App\Http\Controllers\ArtisanController::class, 'subscribeUser'])->name('artisan.subscribe_user');
	Route::get('artisan/{uid}/block', [App\Http\Controllers\ArtisanController::class, 'block'])->name('artisan.block');
	Route::get('artisan/{uid}/unblock', [App\Http\Controllers\ArtisanController::class, 'unblock'])->name('artisan.unblock');
	Route::get('artisan/{uid}/unbusy', [App\Http\Controllers\ArtisanController::class, 'unbusy'])->name('artisan.unbusy');
	
	
	
	Route::get('tasks/{subServiceId}/service/{serviceId}', [App\Http\Controllers\ServiceController::class, 'task'])->name('service.tasks');
	Route::get('artisan/{subServiceId}/type/{serviceId}', [App\Http\Controllers\ArtisanController::class, 'getArtisanService'])->name('artisan.userType');



	Route::post('service/store', [App\Http\Controllers\ServiceController::class, 'store'])->name('service.store');

	Route::post('service/{serviceId}/type/{userType}/sub_service/store', [App\Http\Controllers\ServiceController::class, 'storeSubservice'])->name('service.sub_service.store');
	Route::post('task/{serviceId}/store', [App\Http\Controllers\ServiceController::class, 'storeTask'])->name('task.store');


	Route::put('service/update/{id}', [App\Http\Controllers\ServiceController::class, 'update'])->name('service.update');
	Route::put('artisan/update-identity/{id}', [App\Http\Controllers\ArtisanController::class, 'updateVerificationNumber'])->name('artisan.updateVerificationNumber');
	Route::put('wallet/update/{uid}', [App\Http\Controllers\CustomerController::class, 'updateEarnings'])->name('wallet.updateEarnings');
	Route::put('home/update-subscription', [App\Http\Controllers\HomeController::class, 'updateSupplierSub'])->name('home.updateSupplierSub');

	Route::put('subservice/update/{id}/service/{serviceId}', [App\Http\Controllers\ServiceController::class, 'subServiceUpdate'])->name('service.subServiceUpdate');
	Route::put('task/update/{id}/service/{serviceId}', [App\Http\Controllers\ServiceController::class, 'taskUpdate'])->name('task.update');
});

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
